//
//  OPRoom.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPRoom.h"
#import "OPRoomLayer.h"
#import "OPPlayer.h"
#import "OPApplication.h"
#import "OPTrigger.h"
#import "OPItem.h"
#import "OPSprite.h"

NSString *OPSpawnEnemyNotification = @"OPSpawnEnemyNotification";

@implementation OPRoom
- (id)initWithRoomData:(NSString *)roomData
{
	self = [super init];
	if(self != nil) {
		scroll = NSZeroPoint;
		roomLayers = nil;
		currentRoom = NO;
		if(roomData != nil) {
			roomLayers = [[NSMutableArray alloc] init];
			NSString *data = [NSString stringWithContentsOfFile:roomData];
			triggers = [[NSMutableArray alloc] init];
			items  = [[NSMutableArray alloc] init];
			[self loadLayerData:data];
		}
		player = nil;
		enemyList = nil;
		enemies = nil;
	}
	return self;
}


- (void)loadLayerData:(NSString *)inData
{
	NSArray *theLayers = [inData componentsSeparatedByString:@"-\n"];

	NSEnumerator *enumerator = [theLayers objectEnumerator];
	id layerData;
	while((layerData = [enumerator nextObject]) != nil) {
		OPRoomLayer *theLayer = [[[OPRoomLayer alloc] initLayerData:layerData] autorelease];
		[roomLayers addObject:theLayer];
	}
	
}

- (void)loadEventData:(NSDictionary *)triggerData withName:(NSString *)triggerName
{
	OPTrigger *theNewTrigger = [[OPTrigger alloc] initWithEventData:triggerData];
	[theNewTrigger setIdentifier:triggerName];
	[theNewTrigger autorelease];
	[triggers addObject:theNewTrigger];
}

- (void)loadEnemyList:(NSArray *)inData
{
	enemyList = [inData retain];
}

- (void)dealloc
{
	[roomLayers release];
	[triggers release];
	player = nil;
	[super dealloc];
}

- (void)setCurrent
{
	currentRoom = YES;
	player = [NSApp player];
}

- (void)removeCurrent
{
	currentRoom = NO;
	player = nil;
}

- (BOOL)isCurrent
{
	return currentRoom;
}

- (void)draw
{
	glPushMatrix();
		glTranslatef(scroll.x, scroll.y, 0.0);
		[(OPRoom *)[roomLayers objectAtIndex:OPLayerBackground] draw];
		[(OPRoom *)[roomLayers objectAtIndex:OPlayerObjects] draw];
		[items makeObjectsPerformSelector:@selector(draw)];
		if([self isCurrent]) {
			[self drawPlayer];
			[enemies makeObjectsPerformSelector:@selector(draw)];
		}
		[(OPRoom *)[roomLayers objectAtIndex:OPLayerForeground] draw];
		[triggers makeObjectsPerformSelector:@selector(draw)];
	glPopMatrix();
}

- (void)update
{
	if([self isCurrent]) {
		[roomLayers makeObjectsPerformSelector:@selector(update)];
		[enemies makeObjectsPerformSelector:@selector(update)];
	}
}


- (void)scrollXBy:(int)value
{
	scroll.x += value;
}

- (void)scrollYBy:(int)value
{
	scroll.y += value;
}

- (int)xOffset
{
	return scroll.x;
}

- (int)yOffset
{
	return scroll.y;
}

- (void)drawPlayer
{
	[player draw];
}

- (void)resetScroll
{
	[self resetXScroll];
	[self resetYScroll];
}

- (void)resetXScroll
{
	scroll.x = 0;
}

- (void)resetYScroll
{
	scroll.y = 0;
}

- (OPRoomLayer *)layer:(OPLayer)layer
{
	return [roomLayers objectAtIndex:layer];
}

- (OPSprite *)tileOnObjectLayerAtX:(int)x andY:(int)y 
{
	return [[roomLayers objectAtIndex:OPlayerObjects] tileAtX:x andY:y];
}

- (NSArray *)triggers
{
	return triggers;
}

- (OPPlayer *)player
{
	return player;
}

- (void)addItem:(OPItem *)anItem
{
	[items addObject:anItem];
}

- (NSMutableArray *)items
{
	return items;
}

- (void)spawnEnemies
{
	if(enemies) {
		[enemies release];
		enemies = nil;
	}
	enemies = [[NSMutableArray alloc] init];
	NSEnumerator *enumerator = [enemyList objectEnumerator];
	NSString *enemyName;
	//OPApplication *OPApp = (OPApplication *)[OPApplication sharedApplication];
	while((enemyName = [enumerator nextObject]) != nil) {
		NSDictionary *enemyData = [[NSApp enemyMap] objectAtIndex:[enemyName intValue]];
		[[NSNotificationCenter defaultCenter] postNotificationName:OPSpawnEnemyNotification object:self userInfo:enemyData];
	}
}

- (void)removeEnemies
{
	[enemies release];
	enemies = nil;
}

- (NSMutableArray *)enemies
{
	return enemies;
}

- (void)entered
{
//	NSLog(@"Room Entered");
	[self spawnEnemies];
}

- (void)exited
{
//	NSLog(@"Room Exited");
	[self removeEnemies];
	[items release];
	items = [[NSMutableArray alloc] init];
}
@end
